
    (*  Various monitor-calls *)

    (*      For further reference - see Sintran III Reference Manual *)

    function    inbt ( dev : integer ): char; extern;    
        (* return a character from device dev, with parity stripped *)
    procedure   m8out ( Dev : integer; VAR Buffer : integer );extern;
        (* output up to 8 bytes on device dev.  (possibly terminated by
         * a <nul> byte.)  Registers only used for parameter passing.
         *)
    procedure   xbrkm ( Dev : integer; Mode : integer;
                        VAR BrkTab : integer; NByt : integer ); extern;
        (* set break strategy, but possible to use "user-defined" break
         * strategy.
         *)
    procedure   t8inb ( Dev : integer; Var Data : integer;
                        VAR BreakRead : boolean; VAR NByt : integer );extern;
        (* read up to 8 bytes from device dev.  Currently not used 
         *)
    function    cxor ( ch1, ch2 : char ): char; extern;
        (* return the logical xor between ch1 and ch2 *)
    function    isize ( dev : integer ): integer; extern;    
        (* return number of pending characters on device dev *)
    function    iand ( i1 , i2 : integer ): integer; extern;
        (* return logical and between i1 and i2 *)
    function    ior ( i1 , i2 : integer ): integer; extern;
        (* return logical or between i1 and i2 *)
    procedure   cibuf ( dev : integer ); extern;
        (* clear input-buffer of device dev *)
    procedure   brkm ( mode : integer ); extern;
        (* define break strategy to be used on the user's terminal *)
    procedure   echom ( mode : integer ); extern;
        (* define echo strategy to be used on the user's terminal *)
    procedure   Descf; extern;
        (* disable abort with <esc> *)
    procedure   Eescf; extern;
        (* enable abort with <esc> *)
    procedure   rsio ( var runmod, idev, odev, usno: integer ); extern;
        (* return runmode, input/output dev and user-ix of current run *)
    procedure   outbt ( dev : integer; ch : char ); extern;
        (* output ch on device dev *)
    procedure   xhold( unit, n : integer); extern;
        (* Put me in Time-queue for n units of time, where unit is:
                1   :   Basic time-units (20 ms)
                2   :   Seconds
                3   :   Minutes         (not used)
                4   :   Hours           (not used)
        *)
    function    xtime : longint; extern;
        (* gives internal time in basic time-units (20 ms) *)
    function    xtusd : longint; extern;
        (* gives CPU time since login measured in basic time-units (20 ms) *)
    procedure   resrv( dev:integer; outp, nowt:boolean;  VAR retcode:integer); extern;
        (* reserve device dev. *)
    procedure   reles( dev:integer; outp:boolean ); extern;
        (* release device dev. *)
    procedure   DoHelp;extern;
        (* Separately compiled help-module *)

