(* tab p ; *)
VAR

(* Miscellaneous scratch variables: *)
    SeqNo           :   integer;
    PackType        :   PacketType;
    ScrPacket       :   Packet;
    PackLen         :   integer;
    ch              :   char;
    Status          :   integer;            (* Return status from RESRV,RELES *)

(* various status info:     *)
    SendPSize       :   integer;    (* Packet size he wants *)
    TimeOut         :   integer;    (* Time-out he wants *)
    SendTimeOut     :   integer;    (* If set beforehand *)
    RcvTimeOut      :   integer;    (* If set beforehand *)
    STSet,RTSet     :   boolean;    (* Has any Time-out been set manually? *)
    Delay           :   integer;    (* Delay before sending *)


    NPad            :   integer;    (* Number of padding-characters he wants *)
    PadChar         :   char;       (* The padding character he wants *)
    Eol             :   char;       (* The EOL he wants *)
    Quote           :   char;       (* The Quote char he wants *)
    Bit8Quote       :   char;       (* 8-bit Quote character to be used *)
    Use8Quote       :   boolean;    (* Is 8-bit quoting in use? *)
    HasSw8Off       :   boolean;    (* Has it been switched off? *)

    CurrState       :   KermitStates;       (* This is the current state of Kermit *)

    Idev,Odev       :   integer;    (* Devices to use for packet transmission *)
    LocalKermit     :   boolean;    (* TRUE if not transmitting by terminal *)
    DisableTimOut   :   boolean;    (* TRUE if timeout is disabled *)

    FileWarning     :   boolean;    (* Avoid overwriting existing file if TRUE *)

    Debug           :   boolean;    (* Debug output off/on *)
            (* if Debug then assert(DbgConnected) *)
    DbgOut          :   text;       (* Files for debug output *)
    DbgConnected    :   boolean;    (* Debug file is connected *)

    InFile,OutFile  :   ByteFile;   (* Files to receive,send *)

    N               :   Integer;    (* Current packet sequence number *)
    OldTry,NumTry   :   Integer;    (* Packet retry counts  *)
    MaxTry          :   Integer;    (* Retry limit before giving up *)


(* Should have been constants, initialized ONCE by InitializeKermit: *)
    SOH             :   char;               (* Start of header = CHR(1) *)
    LegalPackets    :   set of char;        (* valid packet types *)
    CtlMapping,                             (* Control character mapping *)
    OkQuote,                                (* valid control quotes *)
    Ok8Quote        :   set of char;        (* valid 8-bit-quote characters *)

(* For command handler: *)
    VocabTable  :   packed array(. VocabType .) of WordType;
    
(* For statistics: *)

    NChFile,        (* Number of characters read/written from/to file   *)
    NChSent,        (* Number of actual characters transmitted          *)
    NChRcvd,        (* Number of actual characters received             *)
    StartTime,      (* Time when transaction began                      *)
    StopTime,       (* Time when transaction ended                      *)
    StartCpTime,    (* Cpu time used at beginning of transact.          *)
    StopCpTime      (* Cpu time used at end of transact.                *)
        :   longint;
    DidRcv,         (* Send or receive was last?                        *)
    HasDone         (* A transaction has been done, and above data is valid *)
        :   boolean;

