(*  tab p;
 *
 *      Routines for output of debug-info.
 *
 *      Globals:
 *          DbgOut : text       - where all the debug goes.
 *          Debug : boolean     - controls wether debug is wanted or not.
 * 
 *      All routines test on the value of "Debug" - no testing
 *      neccesary before calling any of these routines.
 *
*)

    procedure   DbgNL;
    (*  Globals     :   Debug   ( read )
                        DbgOut
        SideEffects :   Finishes current line on debug-file
    *)
    begin
        if Debug then writeln(DbgOut);
    end;

    procedure   DbgInt( n : integer );
    (*  Globals     :   Debug ( read )
                        DbgOut
        SideEffects :   Writes an integer on DbgOut with default field width
    *)
    begin
        if Debug then write( DbgOut , n );
    end;

    procedure PrintChar( ch : char );
    begin
        if ch IN (.succ(' ')..'~'.) then
            write( DbgOut, ch )
        else
            if ch='/' then 
                write( DbgOut, '//' )
            else
                write( DbgOut, '/', ord( ch ):3:8, '/' );
    end;

    procedure   DbgChar( ch : char );
    (*  Globals     :   Debug ( read )
                        DbgOut
        SideEffects :   Outputs a character on DbgOut.
    *)
    begin
        if Debug then
            PrintChar(ch);
    end;

    procedure   DbgWrite( Str : StringType );
    (*  Abstract    :   Outputs a string to Debug-file. Terminator is '$'.
        Globals     :   Debug   ( read )
                        DbgOut
        SideEffects :   Writes a string on DbgOut
        Input Params:   Str - String to be written
    *)
    var     i : integer;
    begin
        if Debug then
        begin
            i := MinString;
            while   (Str(.i.) <> '$')
                and (i < MaxString) do
            begin
                write( DbgOut, Str(.i.) );
                i := i + 1;
            end;
        end;
    end;

    procedure   DbgState( S : KermitStates );
    begin
        if Debug then
            case S of
                FileData    :   Write( DbgOut, 'FileData  ');
                Init        :   Write( DbgOut, 'Init      ');
                Break       :   Write( DbgOut, 'Break     ');
                FileHeader  :   Write( DbgOut, 'FileHeader');
                EOFile      :   Write( DbgOut, 'EOFile    ');
                Complete    :   Write( DbgOut, 'Complete  ');
                Abort       :   Write( DbgOut, 'Abort     ');
            end;
    end;

    procedure   DbgPacket ( Pack : Packet );
    (*  Abstract    :   Outputs a packet on debug-file.
                        Does a Writeln on debug-file.
        Globals     :   Debug   ( read )
                        DbgOut
        InputParams :   Pack  - Packet to be written on DbgOut.
        SideEffects :   Outputs packet and "NewLine" to DbgOut.
        Uses        :   UnChar
    *)
    var     i : integer;
    begin
        if Debug then
        begin
            with Pack do
            if PType IN LegalPackets then
            begin
                write(DbgOut,'Packet: ');
                PrintChar(count);
                PrintChar(seq);
                PrintChar(pType);
                if count < ' ' then
                    write(DbgOut,'/////// Bad count field in packet! //////')
                else
                    for i := MinString to ord( UnChar ( count ) ) - 3 do
                        PrintChar( Data(.i.) );
            end else
            begin
                write(DbgOut,' DbgPacket: Invalid packet type ');
            end;
            writeln(DbgOut);
        end;
    end;

    procedure DbgShowPacket(VAR Pack:Packet);
    (*  Abstract        :   Writes a packet to the Debug file
                            as DbgPacket, but in greater detail *)

    var     i,packlen : integer;
    begin
        if Debug then
        with Pack do begin
            write(DbgOut,'DbgShowPacket: ');
            if Mark<>SOH then begin
                writeln(DbgOut,' *** Bad StartOfHeader character: / ',ord(Mark):3:8,'/'  );
            end;
            write(DbgOut,'  Seq =');
            if seq<' ' then 
                write(DbgOut, ' BAD')
            else
                write(DbgOut, ord(UnChar(seq)):4 );
            if count<' ' then
                writeln(DbgOut,'  *** Bad Packet Lenght *** ')
            else begin
                PackLen := ord( UnChar(count) );
                write( DbgOut,'  Count = ',PackLen);
                write( DbgOut,'  PType = ');
                PrintChar( PType );
                Writeln( DbgOut );
                if PackLen>MaxString - 3 then PackLen := MaxString - 3;
                for i:=MinString to PackLen-3 do
                    PrintChar( data(.i.) );
                writeln( DbgOut );
            end;
        end (* with *);
    end;


    procedure DbgFileName( VAR Fn : NameType );
    (*  Abstract    :   Writes a file name to the debug file *)
    VAR i : integer;
    begin
        if Debug then
            with Fn do
                for i := 1 to valid do
                    write( DbgOut, String(.i.) );
    end;

