(* tab p; *)        (* Initial tab. pos. for PED/ED     *)
(*$c+ *)            (* allow 8-bit character assignment *)
PROGRAM Kermit(Input,Output);

(*
 *      Kermit for ND-100 & ND-10 machines running Sintran III.
 *      The essential parts are written in Pascal (ND-Pascal).
 *
 *      This version is based on Kermit protocol Version 3.
 *
 *      The "inner" parts of this program was transformed from
 *      the "C" source program in the protocol manual.
 *      
 *      Authors involved in version:
 *      3.0
 *          H}vard Eidnes   :   Main parts of this program,
 *                              translated from the original "C" source.
 *          Anund Lie       :   Got the first version running, and wrote
 *                              the time-out and file-open routines.
 *          Erlend Dahl     :   Help-utility.
 *      3.1
 *          Rabbe Fogelholm :   Bug-fix from version 3.0 to 3.1.
 *                              Corrected unpacking of 8-bit quoted files.
 *                              Corrected initial negotiation.
 *
 *      In addition come the persons who wrote the macine-dependent routines
 *      in MAC, but none of these (except "he") was directly involved in writing
 *      Kermit.
 *
 *                  NTH, Trondheim,  Norway     31.01.84
 *)
$INCLUDE KERMIT-CONST

$INCLUDE KERMIT-TYPE

$INCLUDE KERMIT-VAR

$INCLUDE KERMIT-EXTERN

(*$t- *)  (* No testing HERE! *)
$INCLUDE KERMIT-BASIS
(*$t+ *)

$Include Kermit-command

$Include Kermit-debug

(*$t- *)
$INCLUDE KERMIT-UTILS
(*$t+ *)

$INCLUDE KERMIT-FILE

(*$t- *)
$INCLUDE KERMIT-SEND

$INCLUDE KERMIT-READ
(*$t+ *)

$Include Kermit-Do-Comm

$Include Kermit-Fault

begin
    InitializeKermit;
    writeln('NTH Kermit for ND-10/100 Version ',Version);
    writeln;
    DoCommands;
end.

