TYPE
    StringType      =   packed array (. MinString .. MaxString .) of char;

    NameType        =   record
                            valid       : 0..MaxName;
                            String      : packed array
                                                (. MinName..MaxName .) of char;
                        end;

    ParType         =   record
                            int : integer;
                            Name: NameType;
                        end;

    Char4Array      =   packed array (. 1 .. MaxFType .) of char;

    CommType    =   (   Transmit,
                        Receive,
                        SetParm,
                        Exit,
                        Help,
                        Invalid );

    PacketType  =   (   DataPack,
                        ACKPack,
                        NAKPack,
                        SinitPack,
                        BrkPack,
                        FHeadPack,
                        EOFPack,
                        ErrPack,
                        NoChangePack,   (* for internal use *)
                        TimOutPack,     (*     -  "  -      *)
                        IllPack,        (*     -  "  -      *)
                        ChkIllPack);    (*     -  "  -      *)

    Packet      =   packed record
                        mark    :   char;   (* SOH character *)
                        count   :   char;   (* # bytes following this field *)
                        seq     :   char;   (* sequence number mod 64 *)
                        ptype   :   char;   (* packet-type *)
                        data    :   StringType; (* the data *)
                        (* checksum is last of data *)
                    end;

    EqPtr       =   ^EqRecord;
    EqRecord    =   record
                        case boolean of
                            true  : ( Pack : Packet; );
                            false : (
                                (* Dirty trick - FORTRAN EQUIVALENCE *)
                                (* Added on afterwards - uses also   *)
                                (* pointer forcing through assembly..*)
                                (* May be left out for other systems *)
                                IntArr : array (. 0..MInt .) of integer;
                                )
                    end;

    KermitStates=   (   FileData,
                        Init,
                        Break,
                        FileHeader,
                        EOFile,
                        Complete,
                        Abort );

    Byte        =   0 .. 255;

    ByteFile    =   packed file of Byte;

    (* Following are types for command interpreter *)
    VocabType   =   ( (*  Commands(Sorted):*)                 
                      (*  Auto            *)    AutoSym,
                      (*  Debug           *)    DbgSym,
                      (*  Delay           *)    DelaySym,
                      (*  Exit            *)    ExitSym,
                      (*  File-warning    *)    FWarnSym,
                      (*  Help            *)    HelpSym,
                      (*  Log-file        *)    LogFileSym,
                      (*  No-log-file     *)    NoLogFileSym,
                      (*  Off             *)    OffSym,
                      (*  On              *)    OnSym,
                      (*  Quit            *)    QuitSym,
                      (*  Receive         *)    RcvSym,
                      (*  Send            *)    SendSym,
                      (*  Set             *)    SetSym,
                      (*  Statistics      *)    StatisticsSym,
                      (*  Time-out        *)    TimeOutSym,
                      (*  Use-8-bit-quote *)    Use8Sym
                    );

    VocabSet    =   set of VocabType;

    MatchType   =   (   Exact, Ambigous, NoMatch );

    TerminType  =   (   Esc, QMark, Cr );

    WordStr     =   packed array(. MinWord..MaxWord .)
                        of char;

    WordType    =   record
                        String : WordStr;
                        Valid  : integer;
                    end;

    (* The following type is used as a buffer in order to
     * split a command-line into independent words.
     *)
    CmdLinType  =   record
                        Terminator  : TerminType;
                        Cursor      : integer;
                        PrevCursor  : integer;
                        EndWord     : integer;
                        Valid       : integer;
                        String      : packed array(. MinName..MaxName .) of char;
                    end;

    NListPtr    =   ^NListElt;
    NListElt    =   record
                        Name    :   NameType;
                        AltUsed :   boolean;
                        AltName :   NameType;
                        Next    :   NListPtr;
                    end;

